# Swift Syntax 602 Release Notes

## New APIs

- `SwiftLexicalLookup` - A new Swift unqualified lookup library
  - Description: The library provides a new Swift unqualified lookup implementation detached from the compiler and accessible to outside clients. The query is stateless and can be directly run on swift-syntax syntax tree, with any syntax node functioning as an entry point. It produces an enum-based data structure as a result that partitions collected names based on the lexical scope of introduction. 
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2952
  - Notes: The library follows the behavior of the compiler implementation with some minor differences, such as a different way of handling dollar identifiers `$x` and generic parameters inside extensions. Furthermore, in the future, once the compiler adopts `SwiftLexicalLookup` and it becomes the canonical implementation, results produced by the query will be guaranteed to be correct.

- `DiagnosticMessage` has a new optional property, `category`, that provides a category name and documentation URL for a diagnostic.
  - Description: Tools often have many different diagnostics. Diagnostic categories allow tools to group several diagnostics together with documentation that can help users understand what the diagnostics mean and how to address them. This API allows diagnostics to provide this category information. The diagnostic renderer will provide the category at the end of the diagnostic message in the form `[#CategoryName]`, and can print categories as "footnotes" with its `categoryFootnotes` method.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2981
  - Migration steps: None required. The new `category` property has optional type, and there is a default implementation that returns `nil`. Types that conform to `DiagnosticMessage` can choose to implement this property and provide a category when appropriate.

- `DiagnosticsFormatter` has a new method, `formattedMessage`, that formats a diagnostic message without any corresponding syntax node.
  - Description: Some tools want to use the diagnostics formatter to produce diagnostics that don't relate to source code, or for which the source code isn't available. This API allows them to do so while maintaining consistent presentation.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/3059
  - Migration steps: None required.

- `FixIt.Change` has a new case `replaceText` that performs a textual replacement of a range of text with another string.
  - Description: The other `FixIt.Change` cases provide structured
    modifications to syntax trees, such as replacing specific notes. Some
    clients provide Fix-Its that don't fit well into this structured model. The
    `replaceText` case makes it possible for such clients to express Fix-Its.
  - Pull request: https://github.com/swiftlang/swift-syntax/pull/3030
  - Migration stems: None required.

## API Behavior Changes

## Deprecations

## API-Incompatible Changes

- `ExpandEditorPlaceholdersToTrailingClosures` has changed to `ExpandEditorPlaceholdersToLiteralClosures`
  - Description: Whether function-typed placeholders are expanded to trailing closures is now configurable using a `format` argument to this rewriter. Additionally clients that support nested placeholders may request that the entire expanded closure be wrapped in an outer placeholder, e.g. `<#{ <#foo#> in <#Bar#> }#>`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2897
  - Migration steps: Replace uses of `ExpandEditorPlaceholdersToTrailingClosures` with `ExpandEditorPlaceholdersToLiteralClosures`. The initializer does not need to change: `.init(indentationWidth:)` on the new type provides the same behavior as the old type.
  - Notes: This improves code completion in a SourceKitLSP session where the trailing closure form may be undesirable. The nested placeholders offer more flexibility to end users, in editors that support it.

- `SyntaxArena` and `ParsingSyntaxArena` has changed to SPI
  - Description: `SyntaxArena` and the subclasses were only meant to be used when dealing with `RawSyntax` which is also SPI.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2930
  - Migration steps: Do not use `SyntaxArena` or `ParsingSyntaxArena` directly.
  - Notes: Although the type itself was `public`, most initializers were already SPI and there was no way to retrive them from existing types via public API.

- `SyntaxChildrenIndex` is no longer `ExpressibleByNilLiteral`
  - Description: `nil` used to represent the end index. However, due to a change in the internal structure, the end index must now be retrieved from the collection.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/2925
  - Migration steps: Use `SyntaxChildren.endIndex` instead.
  - Notes: `ExpressibleByNilLiteral` was a mistake. In general, `Collection.Index` should only be created and managed by the collection itself. For example, `Collection.index(after:)` exists, but `Index.advanced(by:)` does not.

- Some cases in `AttributeSyntax.Arguments` choices and related types has been removed
  - Description: Some attributes that used to have special attribute list syntax are now parsed as a regular `AttributeSyntax` with `.argumentList(LabeledExprListSyntax)`.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/3028
  - Migration steps: Use `AttributeSyntax.Arguments.argumentList(LabeledExprListSyntax)` instead.
  - Notes: Removed cases from `AttributeSyntax.Arguments`: `token(TokenSyntax)`, `string(StringLiteralExprSyntax)`, `conventionArguments(ConventionAttributeArgumentsSyntax)`, `conventionWitnessMethodArguments(ConventionWitnessMethodAttributeArgumentsSyntax)`, `opaqueReturnTypeOfAttributeArguments(OpaqueReturnTypeOfAttributeArgumentsSyntax)`, `exposeAttributeArguments(ExposeAttributeArgumentsSyntax)`, `underscorePrivateAttributeArguments(UnderscorePrivateAttributeArgumentsSyntax)`, and `unavailableFromAsyncArguments(UnavailableFromAsyncAttributeArgumentsSyntax)`. Removed Syntax kinds: `ConventionAttributeArgumentsSyntax`, `ConventionWitnessMethodAttributeArgumentsSyntax`, `OpaqueReturnTypeOfAttributeArgumentsSyntax`, `ExposeAttributeArgumentsSyntax`, `UnderscorePrivateAttributeArgumentsSyntax`, and `UnavailableFromAsyncAttributeArgumentsSyntax`.

- `ExpandEditorPlaceholdersToLiteralClosures` & `CallToTrailingClosures` now take a `Syntax` parameter
  - Description: These refactorings now take an arbitrary `Syntax` and return a `Syntax?`. If a non-function-like syntax node is passed, `nil` is returned. The previous `FunctionCallExprSyntax` overloads are deprecated.
  - Pull Request: https://github.com/swiftlang/swift-syntax/pull/3092
  - Migration steps: Insert a `Syntax(...)` initializer call for the argument, and cast the result with `.as(...)` if necessary.
  - Notes: This allows the refactorings to correctly handle macro expansion expressions and declarations.

## Template

- *Affected API or two word description*
  - Description: *A 1-2 sentence description of the new/modified API*
  - Issue: *If an issue exists for this change, a link to the issue*
  - Pull Request: *Link to the pull request(s) that introduces this change*
  - Migration steps: Steps that adopters of swift-syntax should take to move to the new API (required for deprecations and API-incompatible changes).
  - Notes: *In case of deprecations or API-incompatible changes, the reason why this change was made and the suggested alternative*

*Insert entries in chronological order, with newer entries at the bottom*
